package gov.va.vamf.scheduling.varutility.test;


import gov.va.vamf.scheduling.varutility.domain.*;
import gov.va.vamf.scheduling.varutility.exception.BasicValidationException;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ContextConfiguration(locations = { "classpath:applicationContext-test.xml" })
@RunWith(SpringJUnit4ClassRunner.class)
public class RequestEligibilityCriteriaTest {

    List<ClinicalServices> clinicalServices;

    List<ClinicalServices> customRequestClinicalServices;

    @Before
    public void setup() {
        clinicalServices = createClinicalServices();
        customRequestClinicalServices = createClinicalServicesForCustomRequest();
    }

    @After
    public void tearDown() {
    }

    @Test (expected=BasicValidationException.class)
    public void testValidateNullIdThrowsError() {
        RequestEligibilityCriteria requestEligibilityCriteria = new RequestEligibilityCriteria();
        CoreSettings coreSettings = new CoreSettings();
        CoreSetting coreSetting = new CoreSetting();
        coreSetting.setPatientHistoryDuration(365);
        coreSetting.setPatientHistoryRequired("yes");
        coreSetting.setId("323");
        coreSetting.setTypeOfCare("Primary Care");
        coreSettings.add(coreSetting);
        requestEligibilityCriteria.setId("");
        requestEligibilityCriteria.setRequestSettings(coreSettings);
        SchedulingDays schedulingDays = new SchedulingDays();
        for (Day d: Day.values()) {
            SchedulingDay schedulingDay = new SchedulingDay();
            schedulingDay.setCanSchedule(false);
            schedulingDay.setDay(d);
            schedulingDay.setStartTime("");
            schedulingDay.setEndTime("");
            schedulingDays.add(schedulingDay);
        }
        CustomRequestSettings customRequestSettings = new CustomRequestSettings();
        customRequestSettings.add(new CustomRequestSetting("CR1", "Express Care", false, schedulingDays, 1, 1));
        requestEligibilityCriteria.setCustomRequestSettings(customRequestSettings);
        requestEligibilityCriteria.validate("523", clinicalServices, customRequestClinicalServices);
    }

    @Test (expected=BasicValidationException.class)
    public void testValidateIdDoesntMatchSiteCodeThrowsError() {
        RequestEligibilityCriteria requestEligibilityCriteria = new RequestEligibilityCriteria();
        CoreSettings coreSettings = new CoreSettings();
        CoreSetting coreSetting = new CoreSetting();
        coreSetting.setPatientHistoryDuration(365);
        coreSetting.setPatientHistoryRequired("yes");
        coreSetting.setId("323");
        coreSetting.setTypeOfCare("Primary Care");
        coreSettings.add(coreSetting);
        requestEligibilityCriteria.setId("444");
        requestEligibilityCriteria.setRequestSettings(coreSettings);
        SchedulingDays schedulingDays = new SchedulingDays();
        for (Day d: Day.values()) {
            SchedulingDay schedulingDay = new SchedulingDay();
            schedulingDay.setCanSchedule(false);
            schedulingDay.setDay(d);
            schedulingDay.setStartTime("");
            schedulingDay.setEndTime("");
            schedulingDays.add(schedulingDay);
        }
        CustomRequestSettings customRequestSettings = new CustomRequestSettings();
        customRequestSettings.add(new CustomRequestSetting("CR1", "Express Care", false, schedulingDays, 1, 1));
        requestEligibilityCriteria.setCustomRequestSettings(customRequestSettings);
        requestEligibilityCriteria.validate("523", clinicalServices, customRequestClinicalServices);
    }

    @Test (expected=BasicValidationException.class)
    public void testValidateExpressCareRequiredThrowsError() {
        RequestEligibilityCriteria requestEligibilityCriteria = new RequestEligibilityCriteria();
        CoreSettings coreSettings = new CoreSettings();
        CoreSetting coreSetting = new CoreSetting();
        coreSetting.setPatientHistoryDuration(365);
        coreSetting.setPatientHistoryRequired("yes");
        coreSetting.setId("323");
        coreSetting.setTypeOfCare("Primary Care");
        coreSettings.add(coreSetting);
        requestEligibilityCriteria.setId("523");
        requestEligibilityCriteria.setRequestSettings(coreSettings);
        SchedulingDays schedulingDays = new SchedulingDays();
        for (Day d : Day.values()) {
            SchedulingDay schedulingDay = new SchedulingDay();
            schedulingDay.setCanSchedule(false);
            schedulingDay.setDay(d);
            schedulingDay.setStartTime("");
            schedulingDay.setEndTime("");
            schedulingDays.add(schedulingDay);
        }
        CustomRequestSettings customRequestSettings = new CustomRequestSettings();
        customRequestSettings.add(new CustomRequestSetting("CR1", "Express Care", true, schedulingDays, 1, 1));
        requestEligibilityCriteria.setCustomRequestSettings(customRequestSettings);
        requestEligibilityCriteria.validate("523", clinicalServices, customRequestClinicalServices);
    }

    @Test (expected=BasicValidationException.class)
    public void testValidateExpressCareTimeRequiredThrowsError() {
        RequestEligibilityCriteria requestEligibilityCriteria = new RequestEligibilityCriteria();
        CoreSettings coreSettings = new CoreSettings();
        CoreSetting coreSetting = new CoreSetting();
        coreSetting.setPatientHistoryDuration(365);
        coreSetting.setPatientHistoryRequired("yes");
        coreSetting.setId("323");
        coreSetting.setTypeOfCare("Primary Care");
        coreSettings.add(coreSetting);
        requestEligibilityCriteria.setId("523");
        requestEligibilityCriteria.setRequestSettings(coreSettings);
        SchedulingDays schedulingDays = new SchedulingDays();
        for (Day d : Day.values()) {
            SchedulingDay schedulingDay = new SchedulingDay();
            schedulingDay.setCanSchedule(true);
            schedulingDay.setDay(d);
            schedulingDay.setStartTime("");
            schedulingDay.setEndTime("");
            schedulingDays.add(schedulingDay);
        }
        CustomRequestSettings customRequestSettings = new CustomRequestSettings();
        customRequestSettings.add(new CustomRequestSetting("CR1", "Express Care", true, schedulingDays, 1, 1));
        requestEligibilityCriteria.setCustomRequestSettings(customRequestSettings);
        requestEligibilityCriteria.validate("523", clinicalServices, customRequestClinicalServices);
    }

    private List<ClinicalServices>  createClinicalServices() {
        List<ClinicalServices> clinicalServices = new ArrayList<ClinicalServices>();
        ClinicalServices cs1 = new ClinicalServices();
        cs1.setId("323");
        cs1.setName("PRIMARY CARE");
        StopCodes stopCodes1 = new StopCodes();
        stopCodes1.add(new StopCode("323", ""));
        stopCodes1.add(new StopCode("350", ""));
        cs1.setStopCodes(stopCodes1);
        cs1.setCreatedBy("test user");
        cs1.setCreatedDate(new Date());
        cs1.setModifiedBy("test update user");
        cs1.setLastModifiedDate(new Date());
        clinicalServices.add(cs1);
        ClinicalServices cs2 = new ClinicalServices();
        cs2.setId("408");
        cs2.setName("OPTOMETRY");
        StopCodes stopCodes2 = new StopCodes();
        stopCodes2.add(new StopCode("408", ""));
        cs2.setStopCodes(stopCodes2);
        cs2.setCreatedBy("test user");
        cs2.setCreatedDate(new Date());
        cs2.setModifiedBy("test update user");
        cs2.setLastModifiedDate(new Date());
        clinicalServices.add(cs2);
        ClinicalServices cs3 = new ClinicalServices();
        cs3.setId("203");
        cs3.setName("AUDIOLOGY");
        StopCodes stopCodes3 = new StopCodes();
        stopCodes3.add(new StopCode("203", ""));
        stopCodes3.add(new StopCode("31", "35"));
        cs3.setStopCodes(stopCodes3);
        cs3.setCreatedBy("test user");
        cs3.setCreatedDate(new Date());
        cs3.setModifiedBy("test update user");
        cs3.setLastModifiedDate(new Date());
        clinicalServices.add(cs3);
        return clinicalServices;
    }

    private List<ClinicalServices> createClinicalServicesForCustomRequest() {
        List<ClinicalServices> clinicalServicesList = new ArrayList<ClinicalServices>();
        ClinicalServices cs = new ClinicalServices();
        cs.setId("CR1");
        cs.setName("Express Care");
        cs.setCreatedBy("Test User");
        cs.setCreatedDate(new Date());
        cs.setSubmittedRequestLimit(1);
        StopCodes stopCodes = new StopCodes();
        cs.setStopCodes(stopCodes);
        clinicalServicesList.add(cs);
        return clinicalServicesList;
    }
}
